// Individual entries in the linked list
public class LinkedListBlock {
	private long startAddress;	// Start address of free block
	private long endAddress;		// End address of free block
	private long size;			// Total size of free block
	private LinkedListBlock nextBlock;	// Pointer to next block in list
	private LinkedListBlock prevBlock;	// Pointer to previous block in list
	
	// Constructor
	public LinkedListBlock(long start, long end, long size){
		this.startAddress = start;
		this.endAddress = end;
		this.size = size;
		setNextBlock(null);
		setPrevBlock(null);
	}
	
	public long getStartAddress() {
		return startAddress;
	}
	
	public long getEndAddress() {
		return endAddress;
	}
	
	public long getSize() {
		return size;
	}
	
	public LinkedListBlock getNextBlock() {
		return nextBlock;
	}
	
	public void setNextBlock(LinkedListBlock nextBlock) {
		this.nextBlock = nextBlock;
	}

	public LinkedListBlock getPrevBlock() {
		return prevBlock;
	}
	
	public void setPrevBlock(LinkedListBlock prevBlock) {
		this.prevBlock = prevBlock;
	}
	
}
